


#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "driver/i2c.h"
#include "soc/gpio_struct.h"
#include "driver/gpio.h"
#include <string.h>

#include "eid430.h"
#include "eid430_i2c.h"
#include "lis3mdl.h"


#define LIS3MDL_SA1_HIGH_ADDRESS  0b0011110
#define LIS3MDL_SA1_LOW_ADDRESS   0b0011100

#define LIS3MDL_WHO_ID 0x3D

static int16_t lis3mdlTestReg(uint8_t address, uint8_t reg)
{
    int ret;
    uint8_t value;
    i2c_cmd_handle_t cmd = i2c_cmd_link_create();
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (address << 1) | WRITE_BIT, ACK_CHECK_EN);
    i2c_master_write_byte(cmd,reg,ACK_CHECK_EN);
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (address << 1) | READ_BIT, ACK_CHECK_EN);
    i2c_master_read_byte(cmd, &value, NACK_VAL);
    i2c_master_stop(cmd);
    ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
    i2c_cmd_link_delete(cmd);
    if (ret!=ESP_OK)
        {
        int tmp;
        i2c_get_timeout(I2C_MASTER_NUM,&tmp);
        printf("i2c_read_reg tls ret=%x t_out=%d\n",ret,tmp);
        }
    return value;
}

uint8_t lis3mdlInit(LIS3MDL * this, enum LIS3MDLDeviceType device, enum LIS3MDLSA1State sa1)
{
    // Detect the device type and SA1 state if needed, and also see if we
    // can talk to the device.
    uint8_t deviceFound = 0;
    if (device == LIS3MDL_DEVICE_TYPE_AUTO || device == LIS3MDL_DEVICE_TYPE_LIS3MDL)
    {
        if (sa1 != LIS3MDL_SA1_LOW &&
            lis3mdlTestReg(LIS3MDL_SA1_HIGH_ADDRESS, LIS3MDL_WHO_AM_I) == LIS3MDL_WHO_ID)
        {
            sa1 = LIS3MDL_SA1_HIGH;
            device = LIS3MDL_DEVICE_TYPE_LIS3MDL;
            deviceFound = 1;
        }

        if (sa1 != LIS3MDL_SA1_HIGH &&
            lis3mdlTestReg(LIS3MDL_SA1_LOW_ADDRESS, LIS3MDL_WHO_AM_I) == LIS3MDL_WHO_ID)
        {
            sa1 = LIS3MDL_SA1_HIGH;
            device = LIS3MDL_DEVICE_TYPE_LIS3MDL;
            deviceFound = 1;
        }
    }

    if (!deviceFound) { return 0; }

    this->device = device;
    this->address = (sa1 == LIS3MDL_SA1_HIGH) ?
        LIS3MDL_SA1_HIGH_ADDRESS : LIS3MDL_SA1_LOW_ADDRESS;

    return 1;
}

void lis3mdlEnableDefault(LIS3MDL * this)
{
    if (this->device == LIS3MDL_DEVICE_TYPE_LIS3MDL)
    {
        // OM = 11 (ultra-high-performance mode for X and Y); DO = 100 (10 Hz ODR)
        lis3mdlWriteReg(this, LIS3MDL_CTRL_REG1, 0b01110000);
        if (this->lastResult) { return; }

        // FS = 00 (+/- 4 gauss full scale)
        lis3mdlWriteReg(this, LIS3MDL_CTRL_REG2, 0b00000000);
        if (this->lastResult) { return; }

        // MD = 00 (continuous-conversion mode)
        lis3mdlWriteReg(this, LIS3MDL_CTRL_REG3, 0b00000000);
        if (this->lastResult) { return; }

        // OMZ = 11 (ultra-high-performance mode for Z)
        lis3mdlWriteReg(this, LIS3MDL_CTRL_REG4, 0b00001100);
        if (this->lastResult) { return; }
    }
}

void lis3mdlWriteReg(LIS3MDL * this, uint8_t reg, uint8_t value)
{
    int ret;
    i2c_cmd_handle_t cmd = i2c_cmd_link_create();
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (this->address << 1) | WRITE_BIT, ACK_CHECK_EN);
    i2c_master_write_byte(cmd, reg, ACK_CHECK_EN);
    i2c_master_write_byte(cmd, value,ACK_CHECK_EN);
    i2c_master_stop(cmd);
    ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
    i2c_cmd_link_delete(cmd);
    if (ret!=ESP_OK)
        {
        int tmp;
        i2c_get_timeout(I2C_MASTER_NUM,&tmp);
        printf("ret_lismdl_wr=%x t_out=%d\n",ret,tmp);
        }

    this->lastResult = ret; //i2cPerformTransfers(transfers);
}

uint8_t lis3mdlReadReg(LIS3MDL * this, uint8_t reg)
{
    int ret;
    uint8_t value = 0;
    i2c_cmd_handle_t cmd = i2c_cmd_link_create();
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (this->address << 1) | WRITE_BIT, ACK_CHECK_EN);
    i2c_master_write_byte(cmd, reg, ACK_CHECK_EN);
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (this->address << 1) | READ_BIT, ACK_CHECK_EN);
    i2c_master_read_byte(cmd, &value, NACK_VAL);
    i2c_master_stop(cmd);
    ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
    i2c_cmd_link_delete(cmd);
    if (ret!=ESP_OK)
        {
        int tmp;
        i2c_get_timeout(I2C_MASTER_NUM,&tmp);
        printf("i2c_read_reg lismdl ret=%x t_out=%d\n",ret,tmp);
        }

    this->lastResult = ret; // i2cPerformTransfers(transfers);
    return value;
}

// Reads the 3 magnetometer channels and stores them in array m.
void lis3mdlRead(LIS3MDL * this)
{
    int ret;
    uint8_t reg = LIS3MDL_OUT_X_L;
    uint8_t buffer[6];
    /*uint8_t i;
    for(i=0;i<6;i++)
        {
            buffer[i]=lis3mdlReadReg(this,LIS3MDL_OUT_X_L+i);
        }*/
    uint8_t *p_buf=buffer;
    i2c_cmd_handle_t cmd = i2c_cmd_link_create();
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (this->address << 1) | WRITE_BIT, ACK_CHECK_EN);
    i2c_master_write_byte(cmd,reg, ACK_CHECK_EN);
    i2c_master_start(cmd);
    i2c_master_write_byte(cmd, (this->address << 1) | READ_BIT, ACK_CHECK_EN);
    i2c_master_read(cmd,buffer,5,ACK_VAL);
    p_buf+=5;
    i2c_master_read_byte(cmd,p_buf,NACK_VAL);
    i2c_master_stop(cmd);
    ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
    i2c_cmd_link_delete(cmd);
if (ret!=ESP_OK)
    {
    printf("i2c_read_command=%x\n",ret);
    }
/*    else
    {
        printf("data= %x %x %x %x %x %x\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5]);
    }*/
    
    //printf("data= %x %x %x %x %x %x\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5]);
    //this->lastResult =ret; // i2cPerformTransfers(transfers);
    if (this->lastResult) { return; }

    this->m[0] = (int16_t)(buffer[1] << 8 | buffer[0]);
    this->m[1] = (int16_t)(buffer[3] << 8 | buffer[2]);
    this->m[2] = (int16_t)(buffer[5] << 8 | buffer[4]);
}
