
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "driver/i2c.h"
#include "soc/gpio_struct.h"
#include "driver/gpio.h"
#include <string.h>
#include "eid430.h"


#include "max30101.h"

void MaxWriteReg(uint8_t adr,uint8_t data)
{
int ret;
i2c_cmd_handle_t cmd = i2c_cmd_link_create();
i2c_master_start(cmd);
i2c_master_write_byte(cmd, (MAX30101_I2C_ADDRESS << 1) | WRITE_BIT, ACK_CHECK_EN); 
i2c_master_write_byte(cmd,adr,ACK_CHECK_EN);
i2c_master_write_byte(cmd,data,ACK_CHECK_EN);
i2c_master_stop(cmd);
ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
i2c_cmd_link_delete(cmd);
if (ret!=ESP_OK)
    {
    printf("ret_tls_wr=%x\n",ret);
    }
}

uint8_t MaxReadReg(uint8_t adr)
{
int ret;
uint8_t r=0;
i2c_cmd_handle_t cmd = i2c_cmd_link_create();
i2c_master_start(cmd);
i2c_master_write_byte(cmd, (MAX30101_I2C_ADDRESS << 1) | WRITE_BIT, ACK_CHECK_EN); 
i2c_master_write_byte(cmd,adr,ACK_CHECK_EN);
i2c_master_start(cmd);
i2c_master_write_byte(cmd, (MAX30101_I2C_ADDRESS << 1) | READ_BIT, ACK_CHECK_EN);
i2c_master_read_byte(cmd, &r, NACK_VAL);
i2c_master_stop(cmd);
ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
i2c_cmd_link_delete(cmd);
if (ret!=ESP_OK)
    {
    printf("ret_tls_wr=%x\n",ret);
    }
return r;
}

void MaxReadBuffer(uint8_t adr,uint8_t *buffer,uint8_t l)
{
    int ret;
uint8_t *p_last=buffer;
i2c_cmd_handle_t cmd = i2c_cmd_link_create();
i2c_master_start(cmd);
i2c_master_write_byte(cmd, (MAX30101_I2C_ADDRESS << 1) | WRITE_BIT, ACK_CHECK_EN); 
i2c_master_write_byte(cmd,adr,ACK_CHECK_EN);
i2c_master_start(cmd);
i2c_master_write_byte(cmd, (MAX30101_I2C_ADDRESS << 1) | READ_BIT, ACK_CHECK_EN);
if (l>1)
    {
    p_last+=(l-1);
    i2c_master_read(cmd,buffer,l-1,ACK_VAL);
    } 
i2c_master_read_byte(cmd,p_last,NACK_VAL);        
i2c_master_stop(cmd);
ret = i2c_master_cmd_begin(I2C_MASTER_NUM, cmd, 1000 / portTICK_RATE_MS);
i2c_cmd_link_delete(cmd);
if (ret!=ESP_OK)
    {
    printf("ret_tls_wr=%x\n",ret);
    }
    else
    {
        uint8_t i;
        printf("buf[%d]=",l);
        for(i=0;i<l;i++)
            {
                printf(" %x",buffer[i]);
            }
        printf("\n");
    }
    
}

void Max30101Init(struct max30101_config *config)
{ 
 uint8_t id;
 uint8_t mode_cfg;
 printf("Init Max30101...\n");
 id=MaxReadReg(MAX30101_REG_PART_ID);
 printf("id=%x\n",id);
 if (id==MAX30101_PART_ID)
    {
        MaxWriteReg(MAX30101_REG_MODE_CFG,MAX30101_MODE_CFG_RESET_MASK);
        do
        {
           mode_cfg=MaxReadReg(MAX30101_REG_MODE_CFG);
        } while (mode_cfg & MAX30101_MODE_CFG_RESET_MASK);
        MaxWriteReg(MAX30101_REG_FIFO_CFG, config->fifo);
        MaxWriteReg(MAX30101_REG_MODE_CFG, config->mode);
        MaxWriteReg(MAX30101_REG_SPO2_CFG, config->spo2);
        MaxWriteReg(MAX30101_REG_LED1_PA, config->led_pa[0]);
        MaxWriteReg(MAX30101_REG_LED1_PA, config->led_pa[1]);
        MaxWriteReg(MAX30101_REG_LED1_PA, config->led_pa[2]);
#ifdef CONFIG_MAX30101_MULTI_LED_MODE
	    u8_t multi_led[2];
        /* Write the multi-LED mode control registers */
	    multi_led[0] = (config->slot[1] << 4) | (config->slot[0]);
	    multi_led[1] = (config->slot[3] << 4) | (config->slot[2]);
        MaxWriteReg(MAX30101_REG_MULTI_LED, multi_led[0]);
        MaxWriteReg(MAX30101_REG_MULTI_LED+1, multi_led[1]);
#endif
    

    }
}