#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_wifi.h"
#include "esp_system.h"
#include "esp_event.h"
#include "esp_event_loop.h"
#include "nvs_flash.h"

#include "soc/gpio_struct.h"
#include "driver/gpio.h"

#include "lmic.h"
#include "eid430.h"


#include "lorawan_cnf.h"
#include "lorawan.h"

static uint8_t mydata[] = "A";

// Fonction dépendant du capteur
void InitGestionCapteur()
{

    printf("Tache de gestion d'un capteur...\n");
    
    while(1)
    {
    printf("Bouckle infinie\n");
    //Endormissement de la tache
    vTaskDelay(300/ portTICK_PERIOD_MS);
    }

}


//Fonction d'emmission Lora
void SendData()
{
    printf("Send Data on LORAWAN...\n");

    LMIC_setTxData2(LORAWAN_PORT_ChaineCarac, mydata, sizeof(mydata)-1, 0);

    vTaskDelay(1000/ portTICK_PERIOD_MS);

}

//Fonction Principale
void app_main(void)
{

    // Fonction qui initialise la couche Lora et crée la tache principale de l'ordonanceur os_runloop
    InitLoRaWAN(SendData);
    vTaskDelay(500/ portTICK_PERIOD_MS); //attente
   // Fonction qui initialise crée la tache qui va récupérer la valeur du potentiometre
   InitGestionCapteur();
   
}
