#include "freertos/FreeRTOS.h"
#include "freertos/task.h"    
#include "esp_wifi.h"         
#include "esp_system.h"       
#include "esp_event.h"        
#include "esp_event_loop.h"   

#include "soc/gpio_struct.h"
#include "driver/gpio.h"    
#include "driver/adc.h"     
#include "esp_intr_alloc.h" 

#include "eid430.h"  
#include "rom/gpio.h"
#include "HX711.h"   

#define PD_SCK    GPIO_NUM_33
#define DOUT      GPIO_NUM_32
#define RATE      GPIO_NUM_2 

uint32_t lire_jauge()
{     
    uint32_t count = 0;
    int i;             

    while(1==gpio_get_level(DOUT));
    
    for(i=0;i<24;i++)
    {
        gpio_set_level(PD_SCK,1); // horloge passe à 1
        count = count << 1;       // décalage a gauche pour conserver le bit N-1
        ets_delay_us(1);         
        gpio_set_level(PD_SCK,0); // horloge passe à 0
        ets_delay_us(1);
        
        if(1==gpio_get_level(DOUT))
        {
            count+=1;  // si DOUT passe à 1 on met le bit à 1
        }
    }
    gpio_set_level(PD_SCK,1);
    ets_delay_us(1); 
    gpio_set_level(PD_SCK,0); // Gain 128
    count^=0x800000;
    
    return(count);
}

uint32_t lire_moyenne() // Fait la moyenne sur 5 valeurs et la retourne
{
    uint32_t tab[5]; 
    uint32_t moy=0;  
    uint32_t jauge=0;
    int i = 0;       

    for(i=0;i<5;i++)
    {
        jauge = lire_jauge();              
        tab[i] = jauge;                                 
    }

    for(i=0;i<5;i++)  
    {                 
        moy += tab[i];
    }                 

    moy /=5;    
    return(moy);

}

void Init_HX711() // initialisation
{
    gpio_pad_select_gpio(PD_SCK);                   // hologe
    gpio_set_direction(PD_SCK,GPIO_MODE_DEF_OUTPUT);
                                                    
    gpio_pad_select_gpio(DOUT);                     // etat de la conversion 0 terminée / 1 en cours
    gpio_set_direction(DOUT,GPIO_MODE_DEF_INPUT);
                                                    
    gpio_pad_select_gpio(RATE);                     // vitesse de transmission des données
    gpio_set_direction(RATE,GPIO_MODE_DEF_OUTPUT);  
                                                    
    gpio_set_level(PD_SCK,0); // PD_SCK=0;          
    gpio_set_level(RATE,0);   // RATE=0             
}